﻿using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;
using System.Diagnostics;

namespace VIRP.CRS.DAL
{
    public partial class DVEIVRDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public DVEIVRDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public List<DVEIVRENCOUNTER> GetNewEncounters(int maxRecords)
        {
            Stopwatch stopWatch = new Stopwatch();
            stopWatch.Start();

            List<DVEIVRENCOUNTER> encounters = new List<DVEIVRENCOUNTER>();

            using (VIRPDBDataContext dbContext = GetDataContext())
            {
                LogDetails logDetails = new LogDetails("VIRP.CRS.DAL.DVEIVRDB.GetNewEncounters.usp_getnewencounters", "DVEIR SERVICE", 0);
                encounters = dbContext.usp_getnewencounters(maxRecords).ToList();
                LogManager.LogTiming(logDetails);

                ProcessEncounters(encounters);
            }

            stopWatch.Stop();

            LogDetails ld = new LogDetails("VIRP.CRS.DAL.DVEIVRDB.GetNewEncounters", "DVEIR SERVICE", 0);
            ld.Message = "Parameters: (" + maxRecords.ToString() + ") " + "Elapsed Time: " + stopWatch.Elapsed.ToString();
            LogManager.LogDetails(ld);

            return encounters;
        }

        public int GetNewEncounters_Count()
        {
            int? count = -1;
            int objReturn = -1;          

            using (VIRPDBDataContext dbContext = GetDataContext())
            { 
                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "DVEIR SERVICE", 0);
                objReturn = dbContext.usp_getnewencounters_Count(ref count);
                LogManager.LogTiming(logDetails);
            }

            if (null != count)
                objReturn = (int)count;

            return objReturn;
        }

        public List<DVEIVRENCOUNTER> GetEncountersByDate(DateTime startDate, DateTime endDate)
        {
            Stopwatch stopWatch = new Stopwatch();
            stopWatch.Start();

            List<DVEIVRENCOUNTER> encounters = new List<DVEIVRENCOUNTER>();

            using (VIRPDBDataContext dbContext = GetDataContext())
            {
                LogDetails logDetails = new LogDetails("VIRP.CRS.DAL.DVEIVRDB.GetNewEncounters.GetEncountersByDate", "DVEIR SERVICE", 0);
                encounters = dbContext.usp_getencountersbydate(startDate, endDate).ToList();
                LogManager.LogTiming(logDetails);

                ProcessEncounters(encounters);
            }

            stopWatch.Stop();
            
            LogDetails ld = new LogDetails("VIRP.CRS.DAL.DVEIVRDB.GetEncountersByDate", "DVEIR SERVICE", 0);
            ld.Message = "Parameters: (" + startDate.ToString() + ", " + endDate.ToString() + ") " + "Elapsed Time: " + stopWatch.Elapsed.ToString();
            LogManager.LogDetails(ld);

            return encounters;
        }

        public List<DVEIVRENCOUNTER> GetEncountersByRetrieveDate(DateTime startDate, DateTime endDate)
        {
            Stopwatch stopWatch = new Stopwatch();
            stopWatch.Start();

            List<DVEIVRENCOUNTER> encounters = new List<DVEIVRENCOUNTER>();

            using (VIRPDBDataContext dbContext = GetDataContext())
            {
                LogDetails logDetails = new LogDetails("VIRP.CRS.DAL.DVEIVRDB.GetNewEncounters.GetEncountersByRetrieveDate", "DVEIR SERVICE", 0);
                encounters = dbContext.usp_getencountersbysentdate(startDate, endDate).ToList();
                LogManager.LogTiming(logDetails);

                ProcessEncounters(encounters);
            }

            stopWatch.Stop();

            LogDetails ld = new LogDetails("VIRP.CRS.DAL.DVEIVRDB.GetEncountersByRetrieveDate", "DVEIR SERVICE", 0);
            ld.Message = "Parameters: (" + startDate.ToString() + ", " + endDate.ToString() + ") " + "Elapsed Time: " + stopWatch.Elapsed.ToString();
            LogManager.LogDetails(ld);

            return encounters;
        }

        public int GetEncountersByDate_Count(DateTime startDate, DateTime endDate)
        {
            int? count = -1;
            int objReturn = -1;

            using (VIRPDBDataContext dbContext = GetDataContext())
            {
                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "DVEIR SERVICE", 0);
                objReturn = dbContext.usp_getencountersbydate_Count(ref count, startDate, endDate);
                LogManager.LogTiming(logDetails);
            }

            if (null != count)
                objReturn = (int)count;

            return objReturn;
        }

        public int GetEncountersByRetrieveDate_Count(DateTime startDate, DateTime endDate)
        {
            int? count = -1;
            int objReturn = -1;

            using (VIRPDBDataContext dbContext = GetDataContext())
            {
                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "DVEIR SERVICE", 0);
                objReturn = dbContext.usp_getencountersbySentdate_Count(ref count, startDate, endDate);
                LogManager.LogTiming(logDetails);
            }

            if (null != count)
                objReturn = (int)count;

            return objReturn;
        }

        public void ProcessEncounters(List<DVEIVRENCOUNTER> encounters)
        {
            if (encounters.Count() > 0)
            {
                string sEncounterIds = "";

                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    foreach (DVEIVRENCOUNTER de in encounters)
                    {
                        // Build list of encounter id's to mark as retrieved
                        if (sEncounterIds == "")
                        {
                            sEncounterIds = de.ENCOUNTERID.ToString();
                        }
                        else
                        {
                            sEncounterIds += "," + de.ENCOUNTERID.ToString();
                        }

                        // Get Diagnosis and Procedures (they are all details, so we get all the ICD and CPT details, then assign 
                        // to the correct list accordingly

                        List<DVEIVRENCOUNTER_DETAIL> encounterDetails = new List<DVEIVRENCOUNTER_DETAIL>();
                        List<DVEIVRENCOUNTER_DIAGNOSIS> encounterDiagnoses = new List<DVEIVRENCOUNTER_DIAGNOSIS>();
                        List<DVEIVRENCOUNTER_PROCEDURE> encounterProcedures = new List<DVEIVRENCOUNTER_PROCEDURE>();
                        List<DVEIVRENCOUNTER_PROVIDER> encounterProvider = new List<DVEIVRENCOUNTER_PROVIDER>();                        

                        //LogDetails logDetails2 = new LogDetails("VIRP.CRS.DAL.DVEIVRDB.GetNewEncounters.usp_getencounterdetails", "DVEIR SERVICE", 0);
                        encounterDetails = dbContext.usp_getencounterdetails(de.ENCOUNTERID).ToList();
                        //LogManager.LogTiming(logDetails2);

                        foreach (DVEIVRENCOUNTER_DETAIL encDetail in encounterDetails)
                        {
                            switch (encDetail.TYPE.ToUpper())
                            {
                                case "ICD":
                                    DVEIVRENCOUNTER_DIAGNOSIS encDiag = new DVEIVRENCOUNTER_DIAGNOSIS();

                                    encDiag.VISITIDENTIFER = encDetail.VISITIDENTIFER;
                                    encDiag.ICDCODE = encDetail.VALUE;
                                    encDiag.ICDNAME = encDetail.NAME;
                                    encDiag.ICDDESCRIPTION = encDetail.DESCRIPTION;
                                    encDiag.ICDLATERALITY = encDetail.LATERALITYCODE;
                                    encounterDiagnoses.Add(encDiag);
                                    break;

                                case "CPT":
                                    DVEIVRENCOUNTER_PROCEDURE encProc = new DVEIVRENCOUNTER_PROCEDURE();

                                    encProc.VISITIDENTIFER = encDetail.VISITIDENTIFER;
                                    encProc.CPTCODE = encDetail.VALUE;
                                    encProc.CPTNAME = encDetail.NAME;
                                    encProc.CPTDESCRIPTION = encDetail.DESCRIPTION;
                                    encProc.CPTLATERALITY = encDetail.LATERALITYCODE;
                                    encounterProcedures.Add(encProc);
                                    break;

                                default:
                                    LogManager.LogError("DvierDb: Invalid EncounterDetail Type: " + encDetail.TYPE, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                                    break;
                            }
                        }

                        de.DVEIVRENCOUNTERDIAGNOSIS = encounterDiagnoses;
                        de.DVEIVRENCOUNTERPROCEDURE = encounterProcedures;

                        // Get the Provider(s)

                        //LogDetails logDetails3 = new LogDetails("VIRP.CRS.DAL.DVEIVRDB.GetNewEncounters.usp_getproviderforencounter", "DVEIR SERVICE", 0);
                        encounterProvider = dbContext.usp_getproviderforencounter(de.ENCOUNTERID).ToList();
                        //LogManager.LogTiming(logDetails3);

                        de.DVEIVRENCOUNTERPROVIDER = encounterProvider;

                        //if (encounterProvider.Count() > 0)
                        //{
                        //    de.DVEIVRENCOUNTERPROVIDER = encounterProvider[0];
                        //}

                        // Returning more than one isn't necessarily a problem, but let's log it so we know
                        //if (encounterProvider.Count() > 1)
                        //{
                        //    LogDetails logDetails4 = new LogDetails("VIRP.CRS.DAL.DVEIVRDB.GetNewEncounters", "DVEIR SERVICE", 0);
                        //    logDetails4.Message = "Found more than one provider for EncounterId: " + de.ENCOUNTERID.ToString();
                        //    LogManager.LogDetails(logDetails4);
                        //}
                    }

                    // Update these as retrieved before we return
                    int numEncountersUpdated = 0;
                    int objReturn = -1;

                    //LogDetails logDetails = new LogDetails("VIRP.CRS.DAL.DVEIVRDB.GetNewEncounters.usp_updateEncounterstoSent", "DVEIR SERVICE", 0);
                    objReturn = dbContext.usp_updateEncounterstoSent(ref numEncountersUpdated, sEncounterIds);
                    //LogManager.LogTiming(logDetails);

                    if (numEncountersUpdated != encounters.Count)
                    {
                        string errorMessage = "DvierDb.usp_UpdateEncounterstoSent: EncountersToBeUpdated: " + encounters.Count.ToString() + "  EncountersUpdated: " + numEncountersUpdated.ToString();
                        errorMessage += "   FullListOfEncounterIds: " + sEncounterIds;

                        LogManager.LogError(errorMessage, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "DVEIR SERVICE", 0);
                    }
                }
            }
        }
        #endregion
    }
}
